/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.platform;

import java.lang.reflect.Method;

public interface Metrics {
    public static final long LONG_RETVAL_UNLIMITED = -1L;

    public static Metrics systemMetrics() {
        try {
            Class<?> clazz = Class.forName("jdk.internal.platform.CgroupMetrics");
            Method method = clazz.getMethod("getInstance", new Class[0]);
            return (Metrics)method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException);
        }
    }

    public String getProvider();

    public long getCpuUsage();

    public long[] getPerCpuUsage();

    public long getCpuUserUsage();

    public long getCpuSystemUsage();

    public long getCpuPeriod();

    public long getCpuQuota();

    public long getCpuShares();

    public long getCpuNumPeriods();

    public long getCpuNumThrottled();

    public long getCpuThrottledTime();

    public long getEffectiveCpuCount();

    public int[] getCpuSetCpus();

    public int[] getEffectiveCpuSetCpus();

    public int[] getCpuSetMems();

    public int[] getEffectiveCpuSetMems();

    public long getMemoryFailCount();

    public long getMemoryLimit();

    public long getMemoryUsage();

    public long getTcpMemoryUsage();

    public long getMemoryAndSwapLimit();

    public long getMemoryAndSwapUsage();

    public long getMemorySoftLimit();

    public long getBlkIOServiceCount();

    public long getBlkIOServiced();
}

